// CU30Wrap.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "DllLoader.h"
#include "USBDllLoader.h"
#include "CU30Wrap.h"
#define MAX_DEVICES 255
#define TOO_BIG 40500

DeviceRec * devRecs = NULL;
USBdllLoader * usbDll = NULL;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	  case DLL_PROCESS_ATTACH:
      CU30WrapperInit();
    break;
	  case DLL_THREAD_ATTACH:
	  case DLL_THREAD_DETACH:
    break;
	  case DLL_PROCESS_DETACH:
      CU30WrapperDispose();
		break;
	}
    return TRUE;
}
DeviceRec ToDDR(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID)
{
  DeviceRec ddr;
  ddr.DevID       = DevID;
  ddr.EEID        = EEID;
  ddr.USBInstance = USBInstance;
  ddr.USBVersion  = USBVersion;
  return ddr;
}
void FromDDR(DeviceRec ddr, DWORD* USBInstance, DWORD* USBVersion, DWORD* DevID, DWORD* EEID)
{
  *DevID = ddr.DevID;
  *EEID = ddr.EEID;
  *USBInstance = ddr.USBInstance;
  *USBVersion = ddr.USBVersion;
}
extern "C" CU30WRAP_API void __stdcall CU30WrapperInit()
{
  if(usbDll ==  NULL)
    usbDll = new USBdllLoader();
  if(devRecs == NULL)
  {
    devRecs = new DeviceRec[MAX_DEVICES];
    int i;
    for(i=0;i<MAX_DEVICES;i++)
      devRecs[i].EEID = TOO_BIG; // it means, it is not opened
  }
  if ( ! (usbDll->IsLoaded()) )	   CU30WrapperDispose();  // R.L.
}
extern "C" CU30WRAP_API void __stdcall CU30WrapperDispose()
{
  if(devRecs != NULL)
  {
    if(usbDll!= NULL)
    {
      int i;
      for(i=0;i<MAX_DEVICES;i++)
      {
        if(devRecs[i].EEID != TOO_BIG)
          usbDll->CU30Close(devRecs[i]); 
        devRecs[i].EEID = TOO_BIG;
      }        
    }
    delete [] devRecs;
    devRecs = NULL;
  }
  if(usbDll != NULL)
  {
    delete usbDll;
    usbDll = NULL;
  }    
}
extern "C" CU30WRAP_API DWORD __stdcall CU30WEcho(	DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID, WORD w)
{
  DeviceRec ddr;

  if(!usbDll)
    return 0x00;
  ddr = ToDDR(USBInstance, USBVersion, DevID, EEID);
  return usbDll->CU30Echo(ddr,w); 
}
extern "C" CU30WRAP_API DWORD __stdcall CU30WTestReady(	DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID)
{
  DeviceRec ddr;

  if(!usbDll)
    return 0x00;
  ddr = ToDDR(USBInstance, USBVersion, DevID, EEID);
  return usbDll->CU30TestReady(ddr); 
}
// --------------- EEID functions

extern "C" CU30WRAP_API char * __stdcall CU30WOpen(DWORD* USBInstance, DWORD* USBVersion, DWORD* DevID, DWORD* EEID)
{
  if(!usbDll||*EEID<0||*EEID>=MAX_DEVICES)
    return NULL;
  if(devRecs[*EEID].EEID != TOO_BIG)
    return NULL; // it is already opened
  static char * refStr = NULL;
  refStr = "error" ;
  devRecs[*EEID].EEID = *EEID;
  devRecs[*EEID].USBInstance = *USBInstance;
  devRecs[*EEID].USBVersion = *USBVersion;
  devRecs[*EEID].DevID = *DevID;
  usbDll->CU30Open(&devRecs[*EEID],&refStr); 
  return refStr;       
}
extern "C" CU30WRAP_API void __stdcall CU30WClose(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID)
{
  if(!usbDll||EEID<0||EEID>=MAX_DEVICES||devRecs[EEID].EEID == TOO_BIG)
    return;
  usbDll->CU30Close(devRecs[EEID]); 
  devRecs[EEID].EEID = TOO_BIG;
}
extern "C" CU30WRAP_API void __stdcall CU30WStop(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID)
{
  if(!usbDll||EEID<0||EEID>=MAX_DEVICES||devRecs[EEID].EEID == TOO_BIG)
    return;
  usbDll->CU30Stop(devRecs[EEID]); 
}
extern "C" CU30WRAP_API void __stdcall CU30WSweep(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID, int Vel, int Axis, int Timeout)
{
  if(!usbDll||EEID<0||EEID>=MAX_DEVICES||devRecs[EEID].EEID == TOO_BIG)
    return;
  usbDll->CU30Sweep(devRecs[EEID],Vel,Axis,Timeout);
}
extern "C" CU30WRAP_API void __stdcall CU30WStep(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID, int Axis, int n, int Vel)
{
  if(!usbDll||EEID<0||EEID>=MAX_DEVICES||devRecs[EEID].EEID == TOO_BIG)
    return;
  usbDll->CU30Step(devRecs[EEID],Axis,n,Vel);
}
    
extern "C" CU30WRAP_API void __stdcall CU30WDCDCon(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID)
{
  if(!usbDll||EEID<0||EEID>=MAX_DEVICES||devRecs[EEID].EEID == TOO_BIG)
    return;
  usbDll->CU30DCDCon(devRecs[EEID]); 
}
extern "C" CU30WRAP_API void __stdcall CU30WDCDCoff(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID)
{
  if(!usbDll||EEID<0||EEID>=MAX_DEVICES||devRecs[EEID].EEID == TOO_BIG)
    return;
  usbDll->CU30DCDCoff(devRecs[EEID]); 
}

extern "C" CU30WRAP_API int __stdcall CU30WGetEEpromInfo(DWORD USBInstance, DWORD USBVersion, DWORD DevID, DWORD EEID,
    DWORD * pUSBVendorID,DWORD * pUSBProductID,DWORD * pUSBDeviceID,
    DWORD * pDeviceID,DWORD * pEEPromID,DWORD * pVersion,
    DWORD * pSerialNumber,DWORD * pCustomerID,
    char * pCompany,char * pDate,char * pProductStr,char * pCustomer,char * pCustomerStr)
{
  if(!usbDll||EEID<0||EEID>=MAX_DEVICES||devRecs[EEID].EEID == TOO_BIG)
    return 0;
  USBEEProm ubr = usbDll->GetUSBEEPromInfo(devRecs[EEID]); 
  
  *pUSBVendorID = ubr.USBVendorID;
  *pUSBProductID= ubr.USBProductID;
  *pUSBDeviceID = ubr.USBDeviceID;
  *pDeviceID    = ubr.DeviceID;
  *pEEPromID    = ubr.EEPromID;
  *pVersion     = ubr.Version;
  *pSerialNumber= ubr.SerialNumber;
  *pCustomerID  = ubr.CustomerID;
  
#pragma warning(disable : 4996)
  strncpy(pCompany,ubr.Company,32);
  pCompany[31] = '\0';
  strncpy(pDate,ubr.Date,32);
  pDate[31] = '\0';
  strncpy(pProductStr,ubr.ProductStr,32);
  pProductStr[31] = '\0';
  strncpy(pCustomer,ubr.Customer,32);
  pCustomer[31] = '\0';
  strncpy(pCustomerStr,ubr.CustomerStr,32);
  pCustomerStr[31] = '\0';
  return 1;
  #pragma warning(default:4996)
}